clear all
clc
close all


%% Create Data

load AALabData

Y=Action;
Row=row;
features=FeaturesAct;
featGame=FeaturesMatrix;
clear FeaturesMatrix

n=length(Y);
alpha=0.625;
lev1=zeros(n,1);
for i=1:n
    R=Row{i}.^alpha;
    sumR=sum(R,2);
    [~,lev1(i)]=max(sumR);
end


%% Find PDNE

ind=[3,15,27];

FeatParetoDomNE=features(:,ind);
keep=find(sum(FeatParetoDomNE,2)>0);

n=length(Y);
paretonepred=zeros(n,1);
for i=1:n
    if sum(FeatParetoDomNE(i,:))>0
        paretonepred(i)=find(FeatParetoDomNE(i,:));
    else
        paretonepred(i)=randi(3);
    end
end

%% Right branch

ind=[7,34,38];
matrix=featGame(:,ind);

category=zeros(1,n);
for i=1:n
    if matrix(i,3)==1
        category(i)=1;
    elseif matrix(i,3)==0 & matrix(i,2)==1
        category(i)=2;
    elseif matrix(i,3)==0 & matrix(i,2)==0 & matrix(i,1)==1
        category(i)=3;
    else
        category(i)=4;
    end
end

'Category 1'

type1=find(category==1);
n=length(type1)
acclev1=zeros(1,n);
for i=1:n
    h=type1(i);
    acclev1(i)=double(logical(lev1(h)==Y(h)));
end
mean(acclev1)

Q=100;
AccPDNE=zeros(1,Q);
for q=1:Q
    
    paretonepred=zeros(n,1);
    for i=1:n
        h=type1(i);
        if sum(FeatParetoDomNE(h,:))>0
            paretonepred(i)=find(FeatParetoDomNE(h,:));
        else
            paretonepred(i)=randi(3);
        end
    end
    
    accpdne=zeros(1,n);
    for i=1:n
        h=type1(i);
        accpdne(i)=double(logical(paretonepred(i)==Y(h)));
    end
    AccPDNE(q)=mean(accpdne);
end
mean(AccPDNE)

clear acclev1 accpdne AccPDNE

'Category 2'

type2=find(category==2);
n=length(type2)
acclev1=zeros(1,n);
for i=1:n
    h=type2(i);
    acclev1(i)=double(logical(lev1(h)==Y(h)));
end
mean(acclev1)

AccPDNE=zeros(1,Q);
for q=1:10
    paretonepred=zeros(n,1);
    for i=1:n
        h=type2(i);
        if sum(FeatParetoDomNE(h,:))>0
            paretonepred(i)=find(FeatParetoDomNE(h,:));
        else
            paretonepred(i)=randi(3);
        end
    end
    
    accpdne=zeros(1,n);
    for i=1:n
        h=type2(i);
        accpdne(i)=double(logical(paretonepred(i)==Y(h)));
    end
    AccPDNE(q)=mean(accpdne);
end
mean(AccPDNE)


clear acclev1 accpdne AccPDNE


'Category 3'

type3=find(category==3);
n=length(type3)
acclev1=zeros(1,n);
for i=1:n
    h=type3(i);
    acclev1(i)=double(logical(lev1(h)==Y(h)));
end
mean(acclev1)

AccPDNE=zeros(1,Q);
for q=1:Q
    paretonepred=zeros(n,1);
    for i=1:n
        h=type3(i);
        if sum(FeatParetoDomNE(h,:))>0
            paretonepred(i)=find(FeatParetoDomNE(h,:));
        else
            paretonepred(i)=randi(3);
        end
    end
    
    for i=1:n
        h=type3(i);
        accpdne(i)=double(logical(paretonepred(i)==Y(h)));
    end
    AccPDNE(q)=mean(accpdne);
end
mean(AccPDNE)

clear acclev1 accpdne AccPDNE


'Category 4'

type4=find(category==4);
n=length(type4)
acclev1=zeros(1,n);
for i=1:n
    h=type4(i);
    acclev1(i)=double(logical(lev1(h)==Y(h)));
end
mean(acclev1)

AccPDNE=zeros(1,Q);
for q=1:Q
    paretonepred=zeros(n,1);
    for i=1:n
        h=type4(i);
        if sum(FeatParetoDomNE(h,:))>0
            paretonepred(i)=find(FeatParetoDomNE(h,:));
        else
            paretonepred(i)=randi(3);
        end
    end
    
    accpdne=zeros(1,n);
    for i=1:n
        h=type4(i);
        accpdne(i)=double(logical(paretonepred(i)==Y(h)));
    end
    AccPDNE(q)=mean(accpdne);
end
mean(AccPDNE)

clear acclev1 accpdne AccPDNE